//
//  WorldClockViewController.swift
//  Clock
//
//  Created by Dinosaur_Weirdo on 10/21/18.
//  Copyright © 2018 DinoW. All rights reserved.
//

import Cocoa

class WorldClockViewController: NSViewController, NSTableViewDelegate, NSTableViewDataSource {

    let defaults = UserDefaults.standard
    let citiesKey = "cities"
    var do24HourTime = UserDefaults.standard.bool(forKey: "com.DinoW.Do24HourTime")
    
    var cities: [String] = []
    
    var isAddingNewCity = false
    let newCityComboBox = NSComboBox(frame: NSRect(x: 75, y: 249, width: 153, height: 25))
    var cityCountryIDs: [String] = []
    
    @IBOutlet var tableView: NSTableView!
    @IBOutlet var addBtn: NSButton!
    @IBOutlet var clearBtn: NSButton!
    
    var constraintForNotAdding = NSLayoutConstraint()
    var constraintForIsAddingComboBox = NSLayoutConstraint()
    var constraintForIsAddingClearBtn = NSLayoutConstraint()
    
    @objc func addCity(_ sender: Any) {
        if cityCountryIDs.contains(newCityComboBox.stringValue) {
            let city = String(newCityComboBox.stringValue.split(separator: "/")[0])
            if cities.contains(city) {
                print(city)
//                print(cities.firstIndex(of: city))
                tableView.selectRowIndexes(.init(integer: cities.firstIndex(of: city)!), byExtendingSelection: false)
                tableView.scrollRowToVisible(cities.firstIndex(of: city)!)
            } else {
                cities.append(city)
                defaults.set(cities, forKey: citiesKey)
            }
        }
//        addBtn.frame.size.width = 237
        constraintForIsAddingClearBtn = NSLayoutConstraint(item: clearBtn, attribute: .leading, relatedBy: .equal, toItem: newCityComboBox, attribute: .trailing, multiplier: 1.0, constant: 0.0)
        constraintForIsAddingComboBox = NSLayoutConstraint(item: newCityComboBox, attribute: .leading, relatedBy: .equal, toItem: addBtn, attribute: .trailing, multiplier: 1.0, constant: 0.0)
        view.removeConstraint(constraintForIsAddingComboBox)
        view.removeConstraint(constraintForIsAddingClearBtn)
        view.addConstraint(constraintForNotAdding)
        newCityComboBox.deselectItem(at: newCityComboBox.indexOfSelectedItem)
        newCityComboBox.removeFromSuperview()
        constraintForIsAddingComboBox = NSLayoutConstraint()
        constraintForIsAddingClearBtn = NSLayoutConstraint()
        isAddingNewCity = !isAddingNewCity
        tableView.reloadData()
    }
    
    @IBAction func addBtnPressed(_ sender: Any) {
        if isAddingNewCity {
            addCity(sender)
        } else {
            addBtn.frame.size.width = 87
            view.addSubview(newCityComboBox)
            view.printSubviewTree()
            constraintForIsAddingClearBtn = NSLayoutConstraint(item: clearBtn, attribute: .leading, relatedBy: .equal, toItem: newCityComboBox, attribute: .trailing, multiplier: 1.0, constant: 0.0)
            constraintForIsAddingComboBox = NSLayoutConstraint(item: newCityComboBox, attribute: .leading, relatedBy: .equal, toItem: addBtn, attribute: .trailing, multiplier: 1.0, constant: 0.0)
            view.addConstraint(constraintForIsAddingComboBox)
            view.addConstraint(constraintForIsAddingClearBtn)
            view.removeConstraint(constraintForNotAdding)
            constraintForIsAddingComboBox = NSLayoutConstraint()
            constraintForIsAddingClearBtn = NSLayoutConstraint()
            isAddingNewCity = !isAddingNewCity
            tableView.reloadData()
        }
    }
    @IBAction func clearBtnPressed(_ sender: Any) {
        cities.removeAll()
        defaults.set(cities, forKey: citiesKey)
        tableView.reloadData()
    }
    @IBAction func refreshBtnPressed(_ sender: Any) {
        tableView.reloadData()
    }
    @objc func deleteBtnPressed(_ sender: NSButton) {
        cities.remove(at: sender.tag)
        defaults.set(cities, forKey: citiesKey)
        tableView.reloadData()
    }
    
    override func viewDidAppear() {
        do24HourTime = defaults.bool(forKey: "com.DinoW.Do24HourTime")
        tableView.reloadData()
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do view setup here.
        
        defaults.set(false, forKey: "NSConstraintBasedLayoutVisualizeMutuallyExclusiveConstraints")
        
        cities = defaults.array(forKey: citiesKey) as? [String] ?? []
        
        cityCountryIDs = TimeZone.knownTimeZoneIdentifiers.compactMap {
            try? reverse($0, separator: "/")
        }
        
        constraintForNotAdding = NSLayoutConstraint(item: clearBtn, attribute: .leading, relatedBy: .equal, toItem: addBtn, attribute: .trailing, multiplier: 1.0, constant: 0.0)
        clearBtn.superview?.addConstraint(constraintForNotAdding)
        
        newCityComboBox.target = self
        newCityComboBox.action = #selector(addCity(_:))
        newCityComboBox.removeAllItems()
        newCityComboBox.addItems(withObjectValues: cityCountryIDs)
        newCityComboBox.completes = true
        newCityComboBox.numberOfVisibleItems = 10
//        let cn1 = NSLayoutConstraint(item: newCityComboBox, attribute: .leading, relatedBy: .equal, toItem: addBtn, attribute: .trailing, multiplier: 1.0, constant: 0.0)
//        newCityComboBox.superview?.addConstraint(cn1)
        
        for col in tableView.tableColumns {
            col.width = CGFloat(450/tableView.tableColumns.count)
        }
        
        tableView.delegate = self
        tableView.dataSource = self
        tableView.selectionHighlightStyle = .regular
        tableView.headerView = nil
    }
    
    func reverse(_ thing: String, separator: Character) throws -> String {
        let split = thing.split(separator: separator)
        guard split.count == 2 else {
            throw NSError()
        }
        let characterSet: NSCharacterSet = NSCharacterSet(charactersIn: "_") as NSCharacterSet
        return ("\(split[1])\(separator)\(split[0])".components(separatedBy: characterSet as CharacterSet) as NSArray).componentsJoined(by: " ")
    }
    
    func getTimeZoneFromCity(_ city: String) -> TimeZone {
        let characterSet: NSCharacterSet = NSCharacterSet(charactersIn: " ") as NSCharacterSet
        let newCity = (city.components(separatedBy: characterSet as CharacterSet) as NSArray).componentsJoined(by: "_")
        
        let identifiers = TimeZone.knownTimeZoneIdentifiers
        var cityIdentifiers: [String] = []
        for i in identifiers {
            if i.split(separator: "/").count >= 2 {
                cityIdentifiers.append(String(i.split(separator: "/")[1]))
            }
        }
        if cityIdentifiers.contains(newCity) {
            let identifier = identifiers[cityIdentifiers.firstIndex(of: newCity)!]
            return TimeZone(identifier: identifier)!
        } else {
            fatalError("Couldn't find city \(newCity) in identifiers \(cityIdentifiers)")
        }
        
    }
    
    // delegate
    func numberOfRows(in tableView: NSTableView) -> Int {
        return cities.count
    }
    func tableView(_ tableView: NSTableView, viewFor tableColumn: NSTableColumn?, row: Int) -> NSView? {
        let city = cities[row]
        let tz = getTimeZoneFromCity(city)
        
        let cellView = NSView()
        let label = NSTextField(frame: NSRect(x: 0, y: 0, width: 120, height: 40))
        label.isEditable = false
        label.isBezeled = false
        label.font = NSFont.monospacedDigitSystemFont(ofSize: 30, weight: .regular)
        label.usesSingleLineMode = true
        label.drawsBackground = false
        cellView.addSubview(label)
        switch tableColumn {
        case tableView.tableColumns[0]:
            label.font = NSFont.monospacedDigitSystemFont(ofSize: 20, weight: .regular)
            label.frame = NSRect(x: 0, y: 7, width: 150, height: 26)
            label.alignment = .left
            label.stringValue = city
            break
        case tableView.tableColumns[1]:
            let sourceTimezone = TimeZone.current
            let destTimezone = tz
            let sourceEDTOffset = sourceTimezone.secondsFromGMT(for: Date())
            let destEDTOffset = destTimezone.secondsFromGMT(for: Date())
            let timeInterval = destEDTOffset - sourceEDTOffset
            let tiFormatted = "\(String(timeInterval).prefix(1) == "-" ? "-" : "+")\(String(format: "%02d", abs(Int(floor(Double(timeInterval / 3600)))))):\(String(format: "%02d", abs(timeInterval % 60)))"
            label.alignment = .center
            label.stringValue = String(tiFormatted)
            break
        case tableView.tableColumns[2]:
            let dateFormatter = DateFormatter()
            dateFormatter.timeZone = tz
            dateFormatter.dateFormat = do24HourTime ? "HH:mm" : "h:mma"
            let tzDate = dateFormatter.string(from: Date())
            label.frame = NSRect(x: -15, y: -3, width: 130, height: 40)
            label.font = NSFont.monospacedDigitSystemFont(ofSize: 25, weight: .regular)
            label.alignment = .right
            label.stringValue = tzDate
            
            let deleteButton = NSButton(frame: NSRect(x: 110, y: 5, width: 20, height: 20))
            deleteButton.tag = row
            deleteButton.bezelStyle = .circular
            deleteButton.title = "x"
            deleteButton.alignment = .center
            deleteButton.sizeToFit()
            deleteButton.action = #selector(deleteBtnPressed(_:))
            print(row)
            print(deleteButton.tag)
//            print(deleteButton.action)
            cellView.addSubview(deleteButton)
            break
        default:
            print("weird table column: \(String(describing: tableColumn))")
            break
        }
        return cellView
    }
    func tableView(_ tableView: NSTableView, heightOfRow row: Int) -> CGFloat {
        return 40
    }
}

extension WorldClockViewController {
    static func freshController() -> WorldClockViewController {
        let storyboard = NSStoryboard(name: "Main", bundle: nil)
        let identifier = "WorldClockViewController"
        guard let WorldClockViewController = storyboard.instantiateController(withIdentifier: identifier) as? WorldClockViewController else {
            fatalError("Why cant i find WorldClockViewController? - check Main.storyboard")
        }
        return WorldClockViewController
    }
}

extension NSView {
    func printSubviewTree(_ level: Int = 0) {
        print("\(String(repeating: "|\t", count: level))\(type(of: self))")
        for subview in subviews {
            subview.printSubviewTree(level + 1)
        }
    }
}
