//
//  ViewController.swift
//  Clock
//
//  Created by Dinosaur_Weirdo on 6/2/18.
//  Copyright © 2018 DinoW. All rights reserved.
//

import Cocoa

class ViewController: NSViewController {
    
    let defaults = UserDefaults.standard
    let do24HourTimeKey = "com.DinoW.Do24HourTime"
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        
    }
    
    override func viewDidAppear() {
        let dateFormat = defaults.persistentDomain(forName: "com.apple.menuextra.clock")?["DateFormat"] as? String
        let is24Hour = dateFormat?.range(of: "a") == nil
        print("24 hour time: \(is24Hour)")
        defaults.set(is24Hour, forKey: do24HourTimeKey)
    }
    
    override var representedObject: Any? {
        didSet {
        // Update the view, if already loaded.
        }
    }
    
    
}

extension ViewController {
    static func freshController() -> ViewController {
        let storyboard = NSStoryboard(name: "Main", bundle: nil)
        let identifier = "ViewController"
        guard let viewcontroller = storyboard.instantiateController(withIdentifier: identifier) as? ViewController else {
            fatalError("Why cant i find ViewController? - check Main.storyboard")
        }
        return viewcontroller
    }
}
