//
//  TabViewController.swift
//  Clock
//
//  Created by Dinosaur_Weirdo on 10/21/18.
//  Copyright © 2018 DinoW. All rights reserved.
//

import Cocoa

class TabViewController: NSTabViewController {

    let lastSelectedKey = "lastSelected"
    let selectedItem = UserDefaults.standard.integer(forKey: "lastSelected")
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do view setup here.
        
        tabView.selectTabViewItem(at: selectedItem)
    }
    
    override func tabView(_ tabView: NSTabView, didSelect tabViewItem: NSTabViewItem?) {
        UserDefaults.standard.set(selectedTabViewItemIndex, forKey: lastSelectedKey)
    }
    
}

extension TabViewController {
    static func freshController() -> TabViewController {
        let storyboard = NSStoryboard(name: "Main", bundle: nil)
        let identifier = "TabViewController"
        guard let TabViewController = storyboard.instantiateController(withIdentifier: identifier) as? TabViewController else {
            fatalError("Why cant i find TabViewController? - check Main.storyboard")
        }
        return TabViewController
    }
}
