//
//  AppDelegate.swift
//  Clock
//
//  Created by Dinosaur_Weirdo on 6/2/18.
//  Copyright © 2018 DinoW. All rights reserved.
//

import Cocoa
import AVFoundation

@NSApplicationMain
class AppDelegate: NSObject, NSApplicationDelegate, NSUserNotificationCenterDelegate {

    let alertSuppressionKey = "QuitAlertSuppression"
    let defaults = UserDefaults.standard
    
    let statusItem = NSStatusBar.system.statusItem(withLength:NSStatusItem.squareLength)
    let popover = NSPopover()
    var eventMonitor: EventMonitor?
    var reply: NSApplication.TerminateReply = .terminateCancel
    public static let notificationCenter = NSUserNotificationCenter.default

    @objc func togglePopover(_ sender: Any?) {
        if popover.isShown {
            closePopover(sender: sender)
        } else {
            showPopover(sender: sender)
        }
    }
    
    func showPopover(sender: Any?) {
        if let button = statusItem.button {
            popover.show(relativeTo: button.bounds, of: button, preferredEdge: NSRectEdge.minY)
        }
        eventMonitor?.start()
    }
    
    func closePopover(sender: Any?) {
        popover.performClose(sender)
        eventMonitor?.stop()
    }
    
    func applicationDidFinishLaunching(_ aNotification: Notification) {
        if let button = statusItem.button {
            button.image = NSImage(named:"StatusBarButtonImage")
            button.action = #selector(togglePopover(_:))
        }
        popover.contentViewController = ViewController.freshController()
        
        AppDelegate.notificationCenter.delegate = self
        AppDelegate.notificationCenter.removeAllDeliveredNotifications()
        AppDelegate.notificationCenter.scheduledNotifications = []

        
        // add an EventMonitor to close the app whenever you click out of it
        eventMonitor = EventMonitor(mask: [.leftMouseDown, .rightMouseDown]) { [weak self] event in
            if let strongSelf = self, strongSelf.popover.isShown {
                strongSelf.closePopover(sender: event)
            }
        }
    }

    func applicationWillTerminate(_ aNotification: Notification) {
        // Insert code here to tear down your application
        print("test")
        AppDelegate.notificationCenter.scheduledNotifications = []
    }
    
    func applicationShouldTerminate(_ sender: NSApplication) -> NSApplication.TerminateReply {
        // create a dialog box confirming the quit, and if the first button ("quit") was pressed, return .terminateNow, otherwise return .terminateCancel
        
        // check if the user has suppressed the alerts
        if defaults.bool(forKey: alertSuppressionKey) {
            self.reply = .terminateNow
        } else {
            // if this isn't the ugliest code i've ever written in my god damn life...
            
            // walkthrough for when i inevitably try to figure out how this shitshow works: (TL;DR: ugly recursion but it's different the second time)
            // first, we check if self.reply is .terminateCancel; if this is true then it means that the user hasn't hit the Quit button yet; this will be relevant later
            if self.reply == .terminateCancel {
                // create a sheet notification, whose completion returns two bools: whether the user pressed Quit, and whether the suppression box was ticked
                areYouSureQuit(completion: { [unowned self] doQuit,doSuppress in
                    // this function runs asynchronously, so when we return self.reply at the end of the function, it's not actually this version of self.reply (again, this will be relevant later.)
                    self.reply = doQuit ? .terminateNow : .terminateCancel
                    // basically just tells userdefaults that "QuitAlertSuppression" should be whatever doSuppress was, which we check for at the beginning of the function
                    self.defaults.set(doSuppress, forKey: self.alertSuppressionKey)
                    // NSApp.terminate(self) runs applicationShouldTerminate (this function) but now that we've set self.reply to what it should be, the function will skip all of this and just return self.reply, which will be .terminateNow if doQuit is true (doQuit being true is the only time NSApp.terminate(self) is called)
                    if doQuit {
                        NSApp.terminate(self)
                    }
                })
            }
        }
        print("self.reply: \(self.reply == .terminateNow)")
        return self.reply
    }
    
    
    // notification center delegate
    
    // remember when i talked about the code that was the "ugliest code i've ever written"? well i think this has got to claim that title instead
    func userNotificationCenter(_ center: NSUserNotificationCenter, didDeliver notification: NSUserNotification) {
        if notification.identifier![notification.identifier!.startIndex..<notification.identifier!.firstIndex(of: Character("-"))!] == "alarm" {
            let avc = NSApp.windows[2].contentViewController?.children[0].children[1] as! AlarmViewController
            avc.notificationDidDeliver(center, didDeliver: notification)
        } else if notification.identifier![notification.identifier!.startIndex..<notification.identifier!.firstIndex(of: Character("-"))!] == "timer" {
            let tvc = NSApp.windows[2].contentViewController?.children[0].children[2] as! TimerViewController
            tvc.notificationDidDeliver(center, didDeliver: notification)
        }
    }
    
    func userNotificationCenter(_ center: NSUserNotificationCenter, didActivate notification: NSUserNotification) {
        switch notification.activationType {
        case .actionButtonClicked:
            if notification.identifier![notification.identifier!.startIndex..<notification.identifier!.firstIndex(of: Character("-"))!] == "alarm" {
                let avc = NSApp.windows[2].contentViewController?.children[0].children[1] as! AlarmViewController
                avc.notificationDidActivate(center, didActivate: notification)
            } else if notification.identifier![notification.identifier!.startIndex..<notification.identifier!.firstIndex(of: Character("-"))!] == "timer" {
                let tvc = NSApp.windows[2].contentViewController?.children[0].children[2] as! TimerViewController
                tvc.notificationDidActivate(center, didActivate: notification)
            }
            break
        case .contentsClicked:
//            AppDelegate.notificationCenter.removeDeliveredNotification(notification)
//            if let button = statusItem.button {
//                showPopover(sender: button) // this shows the popover in the bottom left corner when the menu bar is hidden
//            }
            break
        default:
            break
        }
    }
    
    @objc func userNotificationCenter(_ center: NSUserNotificationCenter, didDismissAlert notification: NSUserNotification) {
        if notification.identifier![notification.identifier!.startIndex..<notification.identifier!.firstIndex(of: Character("-"))!] == "alarm" {
            let avc = NSApp.windows[2].contentViewController?.children[0].children[1] as! AlarmViewController
            avc.notificationDidDismissAlert(center, didDismissAlert: notification)
        } else if notification.identifier![notification.identifier!.startIndex..<notification.identifier!.firstIndex(of: Character("-"))!] == "timer" {
            let tvc = NSApp.windows[2].contentViewController?.children[0].children[2] as! TimerViewController
            tvc.notificationDidDismissAlert(center, didDismissAlert: notification)
        }
    }
    
    func userNotificationCenter(_ center: NSUserNotificationCenter, shouldPresent notification: NSUserNotification) -> Bool {
        return true
    }
    
    func areYouSureQuit(completion: @escaping (Bool,Bool)->()) {
        let areYouSure = NSAlert()
        areYouSure.messageText = "Are you sure you want to quit?"
        areYouSure.informativeText = "Alarms and timers will not go off if the app is closed."
        areYouSure.addButton(withTitle: "Quit")
        areYouSure.addButton(withTitle: "Cancel")
        areYouSure.showsSuppressionButton = true
        areYouSure.alertStyle = .warning
        print(NSApp.windows)
        areYouSure.beginSheetModal(for: NSApp.windows[2], completionHandler: { result in
            completion(result == NSApplication.ModalResponse.alertFirstButtonReturn, areYouSure.suppressionButton?.state == .on)
        })
    }
    
}
